import * as Google from "expo-auth-session/providers/google";
import * as WebBrowser from "expo-web-browser";

import {
    GOOGLE_ANDROID_CLIENT_ID,
    GOOGLE_IOS_CLIENT_ID,
    GOOGLE_EXPO_CLIENT_ID,
} from "@env";

WebBrowser.maybeCompleteAuthSession();

const GoogleLogin = () => {
    const [request, response, promptAsync] = Google.useAuthRequest({
        expoClientId: GOOGLE_EXPO_CLIENT_ID,
        iosClientId: GOOGLE_IOS_CLIENT_ID,
        androidClientId: GOOGLE_ANDROID_CLIENT_ID,
    });
    return [request, response, promptAsync];
};

export default GoogleLogin;
